<?php
/**
 * SharkGate - SharkActiveDefence
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @category    SharkGate
 * @package     SharkGate_SharkActiveDefence
 * @author      Nikola Jocic
 * @copyright   Copyright (c) 2017 SharkGate LTD (http://www.sharkgate.net)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

class MailgunAPI
{

    /**
     * Grab the parameters and check which method will fit current server config
     *
     * @return void
     */
	function __construct($email, $subject, $msg, $domain = null, $APIkey = null){

		$this->email 	=	$email;
		$this->subject 	=	$subject;
		$this->msg 		=	$msg;
		$this->domain 	=	$domain;
		$this->APIkey 	=	$APIkey;

		if ($this->domain == null){
			$this->domain  = "sandbox884ba6594c9c4a98bf2592c4e0e6cdcc.mailgun.org";
		}		
		if($this->APIkey == null) {
			$this->APIkey = "key-2288bd54cfc1a35b37f9b39b0bed8c8e";
		} 	

		 $emailData = array(
		                'from' 		=>	'SharkActiveDefence <postmaster@'.$this->domain.'>',
		                'to' 		=>	$this->email,
		        		'subject'	=>	$this->subject,
		        		'html'		=>	$this->msg
		    			);		

		if ($this->isExtensionLoaded('curl')) {
			$this->sendMailCurl($emailData, $this->domain, $this->APIkey);	
		} else {
			$this->sendMailAlternative($emailData, $this->domain, $this->APIkey);
		}		
	}

    /**
     * Checks is PHP extension loaded on the server
     *
     * @return boolean
     */
    public function isExtensionLoaded($extName)
    {
        return extension_loaded($extName);
    }    

    /**
     * Send POST request with cURL
     *
     * @return boolean
     */
	public function sendMailCurl($emailData, $domain, $APIkey) {

	    $ch = curl_init('https://api.mailgun.net/v3/'.$domain.'/messages');

	    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	  	curl_setopt($ch, CURLOPT_USERPWD, 'api:'.$APIkey.'');
	    curl_setopt($ch, CURLOPT_POST, true);
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $emailData);
	    curl_setopt($ch, CURLOPT_HEADER, false);
	    curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

	    $result = curl_exec($ch);
	    curl_close($ch);
		
		if (!$result) {
		    return false;
		}	
		return true;
	}

    /**
     * Send POST request with file_get_contents if cURL is disabled on a server
     *
     * @return boolean
     */
	public function sendMailAlternative($emailData, $domain, $APIkey) { 

		$postdata = http_build_query($emailData);

		$context  = stream_context_create(array(
		    'http' => array(
		    	'method'  	=> 	'POST',
		        'header'  	=> 	"Authorization: Basic " . base64_encode("api:".$APIkey),
		        'timeout' 	=> 	20,
		        'content' 	=> 	$postdata
		    )
		));
		$result = file_get_contents('https://api.mailgun.net/v3/'.$domain.'/messages', false, $context);

		 if (!$result) {
		 	return false;
		 }
		 return true;		
	}
}
