<?php
require_once('app/Mage.php');
umask(0);
// Mage::app();
Mage :: app("default")->setCurrentStore( Mage_Core_Model_App :: ADMIN_STORE_ID );

// Set your date range
$startDate = '2020-01-01 00:00:00';
$endDate = '2022-12-31 23:59:59';

// Get order collection within the date range
$orderCollection = Mage::getModel('sales/order')->getCollection()
    ->addFieldToFilter('created_at', array('from' => $startDate, 'to' => $endDate));

// Loop through orders and delete
foreach ($orderCollection as $order) {
    try {
        // Delete order
        $order->delete();

        // Output success message
        echo "Order #" . $order->getIncrementId() . " deleted successfully.\n";
    } catch (Exception $e) {
        // Output error message
        echo "Error deleting order #" . $order->getIncrementId() . ": " . $e->getMessage() . "\n";
    }
}
